/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.base.VWWSRRRegistryList;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.VWWSWorkflow;
import filenet.vw.toolkit.utils.ws.base.wsrr.IVWWSRREventListener;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRREvent;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRAuthenticationDialog;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.api.wsrr.WSWSRRWsdlDocument;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWWSRRRegistryManager
implements ChangeListener {
    public static int WSRR_AUTHENTICATE_CANCEL = 0;
    public static int WSRR_AUTHENTICATE_SUCCESS = 1;
    public static int WSRR_AUTHENTICATE_FAILED = 2;
    private VWSession m_session = null;
    private VWWSRRRegistryList m_vwRegistryList = null;
    private VWWSRRRegistry[] m_vwWSRRRegistries = null;
    private VWWSRRRegistryItem[] m_vwWSRRRegistryItems = null;
    private VWWSRRRegistry[] m_untrustedSites = null;
    private Vector m_logonOnceList = new Vector();
    private boolean m_bAbortInit = false;
    private boolean m_bPublishCanceled = false;
    private Vector m_changeListeners = new Vector();
    private Vector m_publishListeners = new Vector();

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 09:16:04  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }

    VWWSRRRegistryManager(VWSession session) {
        this.m_session = session;
        this.initData();
    }

    public VWWSRRRegistryList getWSRRRegistryList() {
        return this.m_vwRegistryList;
    }

    public VWWSRRRegistryItem[] getWSRRRegistryItemList() {
        return this.m_vwWSRRRegistryItems;
    }

    public VWSession getVWSession() {
        return this.m_session;
    }

    protected void initData() {
        this.m_vwRegistryList = new VWWSRRRegistryList(this.m_session);
        if (this.m_vwRegistryList != null) {
            this.m_vwWSRRRegistries = this.m_vwRegistryList.getWSRRRegistries();
            if (this.m_vwWSRRRegistries != null && this.m_vwWSRRRegistries.length > 0) {
                Vector<VWWSRRRegistry> v = new Vector<VWWSRRRegistry>();
                this.m_vwWSRRRegistryItems = new VWWSRRRegistryItem[this.m_vwWSRRRegistries.length];
                for (int i = 0; i < this.m_vwWSRRRegistries.length; ++i) {
                    if (this.m_bAbortInit) {
                        return;
                    }
                    if (this.m_vwWSRRRegistries[i] == null) {
                        return;
                    }
                    if (!this.m_vwWSRRRegistries[i].getPublish()) continue;
                    int eventStatus = 0;
                    try {
                        this.m_vwWSRRRegistryItems[i] = new VWWSRRRegistryItem(this.m_session, this.m_vwWSRRRegistries[i]);
                        this.m_vwWSRRRegistryItems[i].addChangeListener(this);
                        this.m_vwWSRRRegistryItems[i].setState(1);
                        eventStatus = 1;
                    }
                    catch (VWException ex) {
                        if (this.m_vwWSRRRegistryItems[i] != null) {
                            this.m_vwWSRRRegistryItems[i].setState(2);
                        }
                        eventStatus = 2;
                        v.add(this.m_vwWSRRRegistries[i]);
                        VWDebug.logException(ex, VWResource.s_failedToCreateWSRRObject.toString(this.m_vwWSRRRegistries[i].getServerName()));
                    }
                    if (this.m_vwWSRRRegistryItems[i] == null) continue;
                    VWWSRREvent wsrrEvent = new VWWSRREvent(this.m_vwWSRRRegistryItems[i], 5, eventStatus, null, i);
                    ChangeEvent event = new ChangeEvent(wsrrEvent);
                    this.notifyChangeListener(event);
                }
                if (this.m_bAbortInit) {
                    return;
                }
                if (v != null && v.size() > 0) {
                    this.m_untrustedSites = new VWWSRRRegistry[v.size()];
                    v.toArray(this.m_untrustedSites);
                } else {
                    this.m_untrustedSites = null;
                }
            }
        }
    }

    public void setAbortInit(boolean bAbort) {
        this.m_bAbortInit = bAbort;
    }

    public int authenticateForPublish(Container parent, VWWSRRRegistryItem registryItem) {
        int authenticateStatus = WSRR_AUTHENTICATE_FAILED;
        if (registryItem == null) {
            return authenticateStatus;
        }
        if (!registryItem.getPublish()) {
            return authenticateStatus;
        }
        boolean bRegistryAuthenticated = false;
        try {
            bRegistryAuthenticated = registryItem.isAuthenticated();
        }
        catch (Exception ex) {
            bRegistryAuthenticated = false;
            this.displayError(parent, registryItem.getVWWSRRRegistry(), ex);
        }
        VWWSRRRegistry aRegistry = registryItem.getVWWSRRRegistry();
        WSWSRRRegistry WSRegistry = registryItem.getWSWSRRRegistry();
        boolean bHasPublishCredential = false;
        boolean bIsNonSecureLink = false;
        if (WSRegistry != null) {
            bHasPublishCredential = WSRegistry.hasPublishCredential();
            bIsNonSecureLink = WSRegistry.isNonSecureLink();
        }
        boolean bLogonOnce = this.isLogonOnce(registryItem);
        if (bRegistryAuthenticated && bHasPublishCredential && (bLogonOnce || bIsNonSecureLink)) {
            authenticateStatus = WSRR_AUTHENTICATE_SUCCESS;
        } else {
            String username = aRegistry.getUserName();
            if (username != null && username.length() == 0) {
                username = null;
            }
            Dialog dialog = null;
            if (parent != null) {
                if (parent instanceof Frame) {
                    dialog = new VWWSRRAuthenticationDialog((Frame)parent, username, registryItem.getWSWSRRRegistry());
                } else if (parent instanceof Dialog) {
                    dialog = new VWWSRRAuthenticationDialog((Dialog)parent, username, registryItem.getWSWSRRRegistry());
                }
            }
            if (dialog != null) {
                dialog.setVisible(true);
                if (((VWWSRRAuthenticationDialog)dialog).isCanceled()) {
                    authenticateStatus = WSRR_AUTHENTICATE_CANCEL;
                } else {
                    try {
                        String logonUser = ((VWWSRRAuthenticationDialog)dialog).getUsername();
                        String password = ((VWWSRRAuthenticationDialog)dialog).getPassword();
                        registryItem.getVWWSRRRegistry().setUserName(logonUser);
                        registryItem.getVWWSRRRegistry().setPassword(password);
                        boolean bOK = registryItem.setUserInfo(logonUser, password);
                        if (bOK) {
                            authenticateStatus = WSRR_AUTHENTICATE_SUCCESS;
                            this.addToLogonList(registryItem);
                        }
                    }
                    catch (Exception ex) {
                        this.removeFromLogonList(registryItem);
                        bRegistryAuthenticated = false;
                        this.displayError(parent, registryItem.getVWWSRRRegistry(), ex);
                    }
                }
            }
        }
        return authenticateStatus;
    }

    private void addToLogonList(VWWSRRRegistryItem regItem) {
        if (regItem == null) {
            return;
        }
        String newHost = regItem.getHostName();
        boolean bFound = false;
        for (int i = 0; i < this.m_logonOnceList.size(); ++i) {
            String aHost;
            VWWSRRRegistryItem aRegItem = null;
            aRegItem = (VWWSRRRegistryItem)this.m_logonOnceList.elementAt(i);
            if (aRegItem == null || (aHost = aRegItem.getHostName()) == null || newHost == null || aHost.compareTo(newHost) != 0) continue;
            bFound = true;
        }
        if (!bFound) {
            this.m_logonOnceList.addElement(regItem);
        }
    }

    private void removeFromLogonList(VWWSRRRegistryItem regItem) {
        if (regItem == null) {
            return;
        }
        String newHost = regItem.getHostName();
        for (int i = 0; i < this.m_logonOnceList.size(); ++i) {
            String aHost;
            VWWSRRRegistryItem aRegItem = null;
            aRegItem = (VWWSRRRegistryItem)this.m_logonOnceList.elementAt(i);
            if (aRegItem == null || (aHost = aRegItem.getHostName()) == null || newHost == null || aHost.compareTo(newHost) != 0) continue;
            this.m_logonOnceList.removeElementAt(i);
        }
    }

    public boolean isLogonOnce(VWWSRRRegistryItem regItem) {
        if (regItem == null) {
            return false;
        }
        String newHost = regItem.getHostName();
        for (int i = 0; i < this.m_logonOnceList.size(); ++i) {
            String aHost;
            VWWSRRRegistryItem aRegItem = null;
            aRegItem = (VWWSRRRegistryItem)this.m_logonOnceList.elementAt(i);
            if (aRegItem == null || (aHost = aRegItem.getHostName()) == null || newHost == null || aHost.compareTo(newHost) != 0) continue;
            return true;
        }
        return false;
    }

    public int authenticateForQuery(Container parent, VWWSRRRegistryItem registryItem) {
        int authenticateStatus = WSRR_AUTHENTICATE_FAILED;
        if (registryItem == null) {
            return authenticateStatus;
        }
        boolean bRegistryAuthenticated = false;
        boolean bHasQueryCredential = false;
        try {
            bRegistryAuthenticated = registryItem.isAuthenticated();
        }
        catch (Exception ex) {
            bRegistryAuthenticated = false;
            this.displayError(parent, registryItem.getVWWSRRRegistry(), ex);
        }
        if (registryItem.getWSWSRRRegistry() != null) {
            bHasQueryCredential = registryItem.getWSWSRRRegistry().hasQueryCredential();
        }
        if (bRegistryAuthenticated && bHasQueryCredential) {
            authenticateStatus = WSRR_AUTHENTICATE_SUCCESS;
        }
        return authenticateStatus;
    }

    public void setPublishCanceled(boolean b) {
        this.m_bPublishCanceled = b;
    }

    public int deleteWSDL(Frame parent, VWWSRRRegistryItem registryItem, WSWSRRWsdlDocument documentItem) throws Exception {
        int deleteWSDLStatus;
        String statusString = null;
        int iProgress = 0;
        if (this.authenticateForQuery(parent, registryItem) != WSRR_AUTHENTICATE_SUCCESS) {
            this.fireWSRREvent(registryItem.getHostName(), 3, 2, VWResource.s_unauthorizedUser, iProgress++);
            this.fireWSRREvent(registryItem.getHostName(), 4, 5, VWResource.s_unauthorizedUser, iProgress++);
            return 2;
        }
        String docName = null;
        if (documentItem != null) {
            docName = documentItem.getBsrURI();
            this.fireWSRREvent(docName, 1, 0, null, 0);
            deleteWSDLStatus = 1;
            try {
                WSWSRRRegistry wsWSRRRegistry = registryItem.getWSWSRRRegistry();
                if (wsWSRRRegistry != null) {
                    wsWSRRRegistry.deleteWSDLDocument(docName);
                    statusString = VWResource.s_wsdlDeletedSuccessfully.toString(docName);
                    deleteWSDLStatus = 1;
                }
            }
            catch (Exception ex) {
                statusString = ex.getLocalizedMessage();
                if (statusString == null || statusString.length() <= 0) {
                    statusString = ex.toString();
                }
                deleteWSDLStatus = 2;
            }
        } else {
            deleteWSDLStatus = 2;
            statusString = VWResource.s_invalidWsdl;
        }
        this.fireWSRREvent(docName, 3, deleteWSDLStatus, statusString, iProgress++);
        this.fireWSRREvent(registryItem.getHostName(), 2, 0, VWResource.s_ellipse.toString(VWResource.s_refresh), iProgress++);
        registryItem.refresh();
        this.fireWSRREvent(registryItem.getHostName(), 2, 0, null, iProgress + 2);
        this.fireWSRREvent(docName, 4, 4, null, iProgress++);
        return deleteWSDLStatus;
    }

    public void publishService(Frame parent, VWWSRRRegistryItem registryItem, VWWSWorkflow[] workflows) throws Exception {
        int publishStatus;
        this.m_bPublishCanceled = false;
        if (this.authenticateForPublish(parent, registryItem) != WSRR_AUTHENTICATE_SUCCESS) {
            this.fireWSRREvent(workflows[0].getName(), 3, 2, VWResource.s_unauthorizedUser, 0);
            this.fireWSRREvent(workflows, 4, 5, VWResource.s_unauthorizedUser, 0);
            return;
        }
        String name = null;
        VWWorkflowSignature workflowSignature = null;
        int failedCount = 0;
        int successCount = 0;
        int i = 0;
        while (!this.m_bPublishCanceled && workflows != null && i < workflows.length) {
            if (workflows[i] == null) {
                ++i;
                continue;
            }
            workflowSignature = workflows[i].getWorkflowSignature();
            String workflowName = workflows[i].getName();
            this.fireWSRREvent(workflowName, 1, 0, null, i);
            String statusString = VWResource.s_workflowPublishedSuccessfully.toString(name);
            publishStatus = 1;
            if (workflowSignature != null) {
                name = workflowSignature.getName();
                try {
                    WSWSRRRegistry wsWSRRRegistry = registryItem.getWSWSRRRegistry();
                    if (wsWSRRRegistry != null) {
                        wsWSRRRegistry.publish(workflowSignature);
                        ++successCount;
                    }
                }
                catch (Exception ex) {
                    ++failedCount;
                    statusString = ex.getLocalizedMessage();
                    if (statusString == null || statusString.length() <= 0) {
                        statusString = ex.toString();
                    }
                    publishStatus = 2;
                }
            } else {
                publishStatus = 2;
                statusString = VWResource.s_noWorkflowSignature.toString(workflows[i].getName());
            }
            this.fireWSRREvent(workflowName, 3, publishStatus, statusString, i);
            ++i;
        }
        this.fireWSRREvent(registryItem.getHostName(), 2, 0, VWResource.s_ellipse.toString(VWResource.s_refresh), i);
        registryItem.refresh();
        this.fireWSRREvent(registryItem.getHostName(), 2, 0, null, i + 1);
        publishStatus = i >= workflows.length ? 4 : 3;
        this.fireWSRREvent(workflows, 4, publishStatus, null, i);
    }

    private void fireWSRREvent(Object source, int eventType, int status, String message, int refCount) {
        if (this.m_publishListeners != null) {
            VWWSRREvent evt = new VWWSRREvent(source, eventType, status, message, refCount);
            for (int k = 0; k < this.m_publishListeners.size(); ++k) {
                ((IVWWSRREventListener)this.m_publishListeners.get(k)).WSRRBusinessChanged(evt);
            }
        }
    }

    private void displayError(Container container, VWWSRRRegistry wsrrRegistry, Exception ex) {
        if (wsrrRegistry != null) {
            String msg = "\n" + wsrrRegistry.getServerName() + "\n" + wsrrRegistry.getPort();
            this.showMessage(container, VWResource.s_failedToValidateServerCertificate.toString(msg), VWResource.s_error, 1, ex);
        }
    }

    private String showMessage(Container container, String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        if (container instanceof Frame) {
            VWMessageDialog.showOptionDialog((Frame)container, msg, title, msgType);
        } else if (container instanceof JDialog) {
            VWMessageDialog.showOptionDialog((JDialog)container, msg, title, msgType);
        } else {
            JOptionPane.showMessageDialog(container, msg, title, msgType);
        }
        return msg;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.m_changeListeners == null) {
            this.m_changeListeners = new Vector();
        }
        if (l != null && !this.m_changeListeners.contains(l)) {
            this.m_changeListeners.add(l);
        }
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.m_changeListeners != null && l != null && this.m_changeListeners.contains(l)) {
            this.m_changeListeners.remove(l);
        }
    }

    public synchronized void addPublishListener(IVWWSRREventListener l) {
        if (this.m_publishListeners == null) {
            this.m_publishListeners = new Vector();
        }
        if (l != null && !this.m_publishListeners.contains(l)) {
            this.m_publishListeners.add(l);
        }
    }

    public synchronized void removePublishListener(IVWWSRREventListener l) {
        if (this.m_publishListeners != null && l != null && this.m_publishListeners.contains(l)) {
            this.m_publishListeners.remove(l);
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof VWWSRRRegistryItem) {
            this.notifyChangeListener(e);
        }
    }

    protected void notifyChangeListener(ChangeEvent evt) {
        if (this.m_changeListeners != null) {
            for (int i = 0; i < this.m_changeListeners.size(); ++i) {
                ((ChangeListener)this.m_changeListeners.get(i)).stateChanged(evt);
            }
        }
    }
}

